Ext.data.JsonP.sol_common_ix_SubscriptionUtils({"tagname":"class","name":"sol.common.ix.SubscriptionUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.ix.SubscriptionUtils.js","href":"lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getFeedGuid","tagname":"method","owner":"sol.common.ix.SubscriptionUtils","id":"method-getFeedGuid","meta":{}},{"name":"hasSubscription","tagname":"method","owner":"sol.common.ix.SubscriptionUtils","id":"method-hasSubscription","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"subscribe","tagname":"method","owner":"sol.common.ix.SubscriptionUtils","id":"method-subscribe","meta":{}},{"name":"subscribeToElement","tagname":"method","owner":"sol.common.ix.SubscriptionUtils","id":"method-subscribeToElement","meta":{}},{"name":"unsubscribe","tagname":"method","owner":"sol.common.ix.SubscriptionUtils","id":"method-unsubscribe","meta":{}},{"name":"unsubscribeFromElement","tagname":"method","owner":"sol.common.ix.SubscriptionUtils","id":"method-unsubscribeFromElement","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ix.SubscriptionUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.SubscriptionUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils' target='_blank'>lib_sol.common.ix.SubscriptionUtils.js</a></div></pre><div class='doc-contents'><p>Subscription utilities</p>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getFeedGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SubscriptionUtils'>sol.common.ix.SubscriptionUtils</span><br/><a href='source/lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils-method-getFeedGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SubscriptionUtils-method-getFeedGuid' class='name expandable'>getFeedGuid</a>( <span class='pre'>objId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieve the feed guid of an element ...</div><div class='long'><p>Retrieve the feed guid of an element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasSubscription' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SubscriptionUtils'>sol.common.ix.SubscriptionUtils</span><br/><a href='source/lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils-method-hasSubscription' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SubscriptionUtils-method-hasSubscription' class='name expandable'>hasSubscription</a>( <span class='pre'>objId</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if the user has subscribed to an elements feed. ...</div><div class='long'><p>Checks, if the user has subscribed to an elements feed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-subscribe' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SubscriptionUtils'>sol.common.ix.SubscriptionUtils</span><br/><a href='source/lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils-method-subscribe' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SubscriptionUtils-method-subscribe' class='name expandable'>subscribe</a>( <span class='pre'>feedGuid</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Subscribe to a feed. ...</div><div class='long'><p>Subscribe to a feed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>feedGuid</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-subscribeToElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SubscriptionUtils'>sol.common.ix.SubscriptionUtils</span><br/><a href='source/lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils-method-subscribeToElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SubscriptionUtils-method-subscribeToElement' class='name expandable'>subscribeToElement</a>( <span class='pre'>objId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Subscribe to an elements feed. ...</div><div class='long'><p>Subscribe to an elements feed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-unsubscribe' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SubscriptionUtils'>sol.common.ix.SubscriptionUtils</span><br/><a href='source/lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils-method-unsubscribe' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SubscriptionUtils-method-unsubscribe' class='name expandable'>unsubscribe</a>( <span class='pre'>feedGuid</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Unsubscribe from a feed. ...</div><div class='long'><p>Unsubscribe from a feed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>feedGuid</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-unsubscribeFromElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SubscriptionUtils'>sol.common.ix.SubscriptionUtils</span><br/><a href='source/lib_sol.common.ix.SubscriptionUtils.html#sol-common-ix-SubscriptionUtils-method-unsubscribeFromElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SubscriptionUtils-method-unsubscribeFromElement' class='name expandable'>unsubscribeFromElement</a>( <span class='pre'>objId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Unsubscribe from an elements feed. ...</div><div class='long'><p>Unsubscribe from an elements feed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true,"singleton":true}});